﻿using System;
using System.IO;
using System.Text;
using System.Xml.Serialization;

namespace VA.PPMS.IWS.Common
{
    public static class Utilities
    {
        public static string Base64Decode(byte[] base64EncodedBytes)
        {
            return Encoding.UTF8.GetString(base64EncodedBytes);
        }

        public static T Deserialize<T>(string payload)
        {
            try
            {
                var serializer = new XmlSerializer(typeof(T));
                using (var stringReader = new StringReader(payload))
                {
                    var result = (T)serializer.Deserialize(stringReader);
                    return result;
                }
            }
            catch (System.Exception ex)
            {
                throw new PpmsSerializationException(ex.Message);
            }
        }

        public static string SerializeInstance<T>(T classInstance, string prefix, string nameSpace)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));
                var ns = new XmlSerializerNamespaces();

                ns.Add(prefix, nameSpace);

                serializer.Serialize(stream, classInstance, ns);
                return Encoding.UTF8.GetString(stream.ToArray());
            }
        }

        public static string ValidateGuid(string id)
        {
            Guid guid;
            return Guid.TryParse(id, out guid) ? guid.ToString() : string.Empty;
        }

        public static string ValidateInteger(string id)
        {
            int value;
            return int.TryParse(id, out value) ? value.ToString() : string.Empty;
        }

        public static string ValidateParameter(string param)
        {
            var value = ValidateInteger(param);
            if (string.IsNullOrEmpty(value))
            {
                value = ValidateGuid(param);
            }

            return value;
        }
    }
}